﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class MaterialChange : MonoBehaviour
{
    private Material m_redMat;
    private Material[] m_selfMat;//自身材质
    private MeshRenderer m_meshRender;
    private bool m_bControl = true;

    private void Awake()
    {
        m_meshRender = GetComponent<MeshRenderer>();
        m_selfMat = GetComponent<MeshRenderer>().materials;
    }
    //设置红色材质
    public void SetRedMat(Material mat)
    {
        m_redMat = mat;
    }
    //开始材质变化
    public void StartMatChange()
    {
        CancelInvokeChange();
        InvokeRepeating("InvokeChange", 0, 0.25f);
    }
    //重置材质
    public void ResetMat()
    {
        CancelInvokeChange();
        m_bControl = true;
        Material[] varMat = m_meshRender.materials;
        Material[] varM = new Material[varMat.Length];
        for (int i = 0; i < varMat.Length; i++)
        {
            varM[i] = m_selfMat[i];
        }
        m_meshRender.materials = varM;
    }
    //开始变化
    void InvokeChange()
    {
        Material[] varMat = m_meshRender.materials;
        Material[] varM = new Material[varMat.Length];
        for (int i = 0; i < varMat.Length; i++)
        {
            varM[i] = m_bControl ? m_redMat : m_selfMat[i];
        }
        m_meshRender.materials = varM;
        m_bControl = !m_bControl;
    }
    //取消变化
    void CancelInvokeChange()
    {
        if(IsInvoking("InvokeChange"))
        {
            CancelInvoke("InvokeChange");
        }
    }
    private void OnDestroy()
    {
        CancelInvokeChange();
    }
}
